import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import curve_fit

distance_cm = np.array([20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0])
cpm = np.array([6, 10, 21, 21, 17, 26, 23, 45, 63, 51, 73, 89, 103, 130, 170, 212, 321, 485, 796, 1473, 3095])

def model(d, A, b, delta_h):
    return A / ((d + b)**2 + delta_h**2)


initial_guess = [3000, 0.5, 0.5]


popt, pcov = curve_fit(model, distance_cm, cpm, p0=initial_guess)
A_fit, b_fit, delta_h_fit = popt


d_fit = np.linspace(0, 20, 200)
cpm_fit = model(d_fit, *popt)

plt.figure(figsize=(8, 5))
plt.scatter(distance_cm, cpm, color='blue', label='Données expérimentales')
plt.plot(d_fit, cpm_fit, 'r--', label='Courbe ajustée')
plt.xlabel("Distance source-détecteur (cm)")
plt.ylabel("CPM")
plt.title("Ajustement du modèle avec incertitude verticale")
plt.legend()
plt.grid(True)
plt.show()

print(f"a = {A_fit:.2f}")
print(f"b (décalage horiz.) = {b_fit:.4f} cm")
print(f"Δh (décalage vert.) = {delta_h_fit:.4f} cm")